/*
 *  Copyright (c) 2008 Luca Abeni
 *
 *  This is free software; see GPL.txt
 */
#include <sys/poll.h>
#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>

#include "avstreamer.h"
#include "engine.h"
#include "dbg.h"

#define THRESHOLD 1

static int send_handler(int stream, void *c)
{
    int frames;

    frames = rtp_dequeue_frame(c, stream);
    dbg_level_inc();
    dbg_print("Queued frames decreased to %d\n", frames);
    if (frames < THRESHOLD) {
        dbg_print("Now have to read again!!!\n");
        send_frame(c, stream);
    }
    dbg_level_dec();

    return 0;
}

void start_stream(struct rtp_context *rtp_c, void *h)
{
    int i;

    rtp_set_completion(rtp_c, send_handler, rtp_c, h);
    dbg_print("Starting %p\n", rtp_c);
    for (i = 0; i < rtp_num_streams(rtp_c); i++) {
        send_frame(rtp_c, i);
    }
}

struct rtp_context *rtp_session(const char *fname, const char *dst, int ports[], void *h)	/* FIXME */
{
    struct rtp_context *c;
    char sdp[2048];

    c = rtp_stream_create(fname, dst, ports, 0);
    if (c == NULL) {
        return c;
    }
    rtp_get_sdp(c,sdp, sizeof(sdp));
    printf("SDP:\n%s\n", sdp);

    fprintf(stderr, "RTP Context: %p\n", c);
    start_stream(c, h);

    return c;
}

int loop(const char *fname, const char *dst, int ports[])
{
    int done;
    struct event_handler *h;
    void *p;


    done = 0;
    h = event_handler_init();
    p = rtp_session(fname, dst, ports, h);
    while (!done) {
        done = (event_loop(h) == 0);
    }
    rtp_stream_destroy(p);
    
    return 0;
}
