/*
 *  Copyright (c) 2008 Luca Abeni
 *
 *  This is free software; see GPL.txt
 */
#ifndef __ENGINE_H__
#define __ENGINE_H__

struct event_handler;
int event_loop(struct event_handler *h);
int event_new(struct event_handler *h, int fd, int (*handler)(int fd, void *c), void *context);
void *timed_event_new(struct event_handler *h, int64_t time,int (*handler)(uint64_t time, void *c), void *context);
int event_del(struct event_handler *h, int fd);
int timed_event_del(struct event_handler *h, void *h1);
struct event_handler *event_handler_init(void);
void event_handler_cleanup(struct event_handler *h);

#endif	/* __ENGINE_H__ */
