/*
 *  Copyright (c) 2008 Luca Abeni
 *
 *  This is free software; see GPL.txt
 */
#include <stdio.h>
#include <stdarg.h>
#include "dbg.h"

static FILE *log_f;
static int log_active = 0;
static int level;

void dbg_level(int l)
{
    level = l;
}
void dbg_level_inc(void)
{
    level++;
}
void dbg_level_dec(void)
{
    level--;
}
void dbg_print(const char *fmt, ...)
{
    va_list vl;

    if (log_active) {
        int i;
        if (log_f == NULL) {
            log_f = stderr;
        }
        for (i = 0; i < level; i++) fprintf(log_f, "\t");
        va_start(vl, fmt);
        vfprintf(log_f, fmt, vl);
        va_end(vl);
    }
}
