/*
 *  Copyright (c) 2008 Luca Abeni
 *
 *  This is free software; see GPL.txt
 */
#ifndef __AV_STREAMER__
#define __AV_STREAMER__

struct rtp_context;

struct rtp_context *rtp_stream_create(const char *fname, const char *dst, int port[], int delay);
int64_t timeout(void);
void rtp_set_completion(struct rtp_context *rtp_c, int (*hnd)(int index, void *c), void *ctx, void *h);
int rtp_num_streams(struct rtp_context *rtp_c);
int rtp_dequeue_frame(struct rtp_context *rtp_c, int stream);
int send_frame(struct rtp_context *rtp_c, int i);
int rtp_get_buffer(struct rtp_context *rtp_c, int stream, uint8_t **buff);
void rtp_release_buffer(struct rtp_context *rtp_c, int stream, uint8_t *buff);
int rtp_stream_destroy(struct rtp_context *rtp_c);
int rtp_get_sdp(struct rtp_context *rtp_c, char *buff, int size);

#endif	/* __AV_STREAMER__ */
